<div id="product-product" class="container">
  <div class="row">
    <div id="content" class="col-sm-12">
      <div class="row"> 
        <h1 class="pull-right">{{ heading_title }}</h1>
        <div class="col-sm-8"> 
          {% if thumb or images %}
            <ul class="thumbnails">
              {% if thumb %}
                <li><a class="thumbnail" href="{{ popup }}" title="{{ heading_title }}"><img src="{{ thumb }}" title="{{ heading_title }}" alt="{{ heading_title }}" /></a></li>
              {% endif %}
              {% if images %}
                <div class="images-additional">
                  {% for image in images %}
                    <li class="image-additional"><a class="thumbnail" href="{{ image.popup }}" title="{{ heading_title }}"> <img src="{{ image.thumb }}" title="{{ heading_title }}" alt="{{ heading_title }}" /></a></li>
                  {% endfor %}
                </div>
              {% endif %}
            </ul>
          {% endif %}
          <ul class="nav nav-tabs">
            <li class="active"><a href="#tab-description" data-toggle="tab">{{ tab_description }}</a></li>
            {% if attribute_groups %}
              <li><a href="#tab-specification" data-toggle="tab">{{ tab_attribute }}</a></li>
            {% endif %}
            {% if review_status %}
              <li><a href="#tab-review" data-toggle="tab">{{ tab_review }}</a></li>
            {% endif %}
          </ul>
        </div>
        <div class="col-sm-4">
          <div class="input-price">
            <div class="form-group">
              <input type="text" name="quantity" value="{{ minimum }}" size="2" id="input-quantity" class="form-control" />
              <input type="hidden" name="product_id" value="{{ product_id }}" />
            </div>
            {% if price %}
              <ul class="list-unstyled">
                {% if not special %}
                  <li>
                    <h2>{{ price }}</h2>
                  </li>
                {% else %}
                  <li><span style="text-decoration: line-through;">{{ price }}</span></li>
                  <li>
                    <h2>{{ special }}</h2>
                  </li>
                {% endif %}
                {% if discounts %}
                  <li>
                    <hr>
                  </li>
                  {% for discount in discounts %}
                    <li>{{ discount.quantity }}{{ text_discount }}{{ discount.price }}</li>
                  {% endfor %}
                {% endif %}
              </ul>
            {% endif %}
          </div>
          <button type="button" id="button-cart" data-loading-text="{{ text_loading }}" class="btn btn-block">{{ button_cart }}</button>
          <div class="action-buttons">
            <a href="" onclick="wishlist.add('{{ product_id }}'); return false;">
              <span class="action-icon"><i class="far fa-heart"></i></span>
              {{text_wishlist}}
            </a>
            <a href="" onclick="compare.add('{{ product_id }}'); return false;">
              <span class="action-icon"><i class="fas fa-plus-circle"></i></span>
              {{text_compare}}
            </a>
            <a href="" onclick="$('a[href=\'#tab-review\']').trigger('click'); return false;">
              <span class="action-icon"><i class="far fa-edit"></i></span>
              {{ text_write }}
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>